<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\User;
use Stripe\Stripe;
use Stripe\Customer;
use Stripe\EphemeralKey;
use Stripe\PaymentIntent;

class PaymentController extends Controller
{


    public function createStripePaymentSheet(Request $request)
    {
        Stripe::setApiKey(config('services.stripe.secret'));

        $amount = $request->input('amount');

        if (!$amount) {
            return response()->json(['error' => 'Amount is required'], 422);
        }

        $amountInCents = $amount * 100;

        try {
            // 1. Create Stripe customer with no details
            $customer = Customer::create();

            // 2. Create local Laravel user with that Stripe customer ID
            $user = User::create([
                'name' => 'Guest User',
                'email' => 'guest_' . Str::uuid() . '@example.com',
                'password' => bcrypt(Str::random(12)),
                'customer_stripe_id' => $customer->id,
            ]);

            // 3. Create ephemeral key
            $ephemeralKey = EphemeralKey::create(
                ['customer' => $customer->id],
                ['stripe_version' => '2023-10-16']
            );

            // 4. Create payment intent
            $paymentIntent = PaymentIntent::create([
                'amount' => $amountInCents,
                'currency' => 'usd',
                'customer' => $customer->id,
                'automatic_payment_methods' => ['enabled' => true],
            ]);

            return response()->json([
                'paymentIntent' => $paymentIntent->client_secret,
                'ephemeralKey' => $ephemeralKey->secret,
                'customer' => $customer->id,
            ]);

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

}
